(function( $, undefined ) {

$.widget( "ui.pic29MenuRedArrowController", $.Widget, {
	// default options
	options: {
	},
	
	// constructor 
	_create: function() {
		this.current= null;
		this.arrow =null;
		
		this._setInit();
		this._register();
		this._majCorners();
	},
	
	_setInit : function() {
		
		this.current = this.element.find('.current');
		this.arrow   = this.element.find('.arrow');
		
		if(this.current.length != 0) {
			this._setArrowToElement(this.current, false);
		} else {
			this._setArrowToElement(this.element.find('li:first'), false);
			this.arrow.hide();
		}
	},
	
	_register : function() {
		var li = this.element.find('li');
		
		var self = this;
		
		li.each(function(){
			var t = $(this);
			t.bind('mouseover', function() {
				var t = $(this);
				self._setArrowToElement(t);
			});
		});
		
		this.element.bind('mouseleave', function() {
			self._setArrowToElement(self.current);
		});
	},

	_unregister : function() {
		var li = this.element.find('li');
		li.each(function(){
			var t = $(this);
			t.unbind('mouseover');
		});
		this.element.unbind('mouseleave');
	},
	
	_setArrowToElementDirect : function(element) {
		this.arrow.stop();
		if(element.length == 0) {
			this.arrow.hide();
			return;
		}
		
		var position = element.position();
		
		this.arrow.css('left', position.left);
		this.arrow.css('top', position.top + 2);

		if(this.arrow.is(':hidden') == true) {
			this.arrow.show();
		}

	},

	_setArrowToElement : function(element, animate) {
		if (animate == false) {
			this._setArrowToElementDirect(element)
		}
		
		if(element.length == 0) {
			this.arrow.stop().hide();
			return;
		}
		
		if(this.arrow.is(':hidden') == true) {
			//this.arrow.stop().fadeIn();
		}
		
		 
		var position = element.position();
		this.arrow.stop().show().animate({
			left: position.left,
			top: position.top + 2
		}, 500, 'linear', function() {
			//complete
		});
	},

	_majCorners : function () {
		var settings_5 = {
	          tl: { radius: 5 },
	          tr: { radius: 5 },
	          bl: { radius: 5 },
	          br: { radius: 5 },
	          antiAlias: true,
	          autoPad: true
	      };
	  	this.element.find('.cadre').corner(settings_5);
	 },
	
	destroy: function() {
		// call super
		$.Widget.prototype.destroy.apply( this, arguments );
		// now do other stuff particular to this widget
		this._unregister();
	},
	
	_setOption: function( key, value ) {
		// call super
		$.Widget.prototype._setOption.apply( this, arguments );
	}
	
});

$.extend( $.ui.pic29MenuRedArrowController, {
	version: "1.0"
});

})( jQuery );