<?php  
defined('C5_EXECUTE') or die(_("Access Denied."));

	
	
	function page_getChildPages($c) {
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		// a quickie
		$db = Loader::db();
		$r = $db->query("select cID from Pages where cParentID = ? order by cDisplayOrder asc", array($c->getCollectionID()));
		$pages = array();
		while ($row = $r->fetchRow()) {
			$pages[] = Page::getByID($row['cID']);
		}
		return $pages;
	}
	
	function page_canViewPage($c) {
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		$tc = Page::getByID($cID, "ACTIVE"); //recherche la page active
		
		if (!is_object($tc)) {return false;} //elle existe
		
		
		$tcv = $tc->getVersionObject();
	    if (!is_object($tcv)) {return false;}  //A une version
		
		if (!$tcv->isApproved()) {return false;} // A une version approuvée
		
		if ($tc->isSystemPage()) {return false;} //n'est pas une page système 
		//Page Not Found, Page Forbidden etc...
		
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		if ($pagePointerExternalLink != null) {return true;} //si pointeur externe ok
		
		$tcp = new Permissions($tc);
		if (!$tcp->canRead()) {return false;} //est autorisé pour l'utilisateur courant
		
		return true;
	}
	
	function page_getPic29MenuElement($c, $level = 0, $fileterExcludeNav = true) {
		
		if(!page_canViewPage($c)) return null;
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		$tc = Page::getByID($cID, "ACTIVE");
		
		$pic29MenuElement = new Pic29MenuElement();
		$pic29MenuElement->id = $cID;
		$pic29MenuElement->level = $level;
		
		/*
		if ($fileterExcludeNav == true) {
			if ($tc->getCollectionAttributeValue('exclude_nav')) {
				return false;
			}
		} else {
			if ($tc->getCollectionAttributeValue('exclude_nav')) {
				$pic29MenuElement->exclude_nav = true;
			} else {
				$pic29MenuElement->exclude_nav = false;
			}
		}
		*/
		if ($tc->getCollectionAttributeValue('exclude_nav')) {
			$pic29MenuElement->exclude_nav = true;
		} else {
			$pic29MenuElement->exclude_nav = false;
		}
		
		if ($tc->getCollectionAttributeValue('dont_link')) {
			$pic29MenuElement->dont_link = true;
		} else {
			$pic29MenuElement->dont_link = false;
		}
		
		$name = $tc->getCollectionName();
		$pagePath =  $tc->getCollectionPath();
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		$description = $tc->getCollectionDescription();
		
		$pic29MenuElement->label = $name;
		
		$pic29MenuElement->description = null;
		if ($description != null) {
			$description = trim($description);
			if (strcmp('', trim($description)) != 0) {
				$pic29MenuElement->description = $description;
			}
		}
		
		if (isset($pagePointerExternalLink)) {
			$pic29MenuElement->url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$pic29MenuElement->url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($cID == HOME_CID) {
			$pic29MenuElement->url = DIR_REL . '/';
			$pic29MenuElement->isHome = true;
		} else {
			$pic29MenuElement->url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		$childPages = page_getChildPages($c);
		
		$pic29MenuElements = array(); 
		foreach($childPages as $childPage) {
			$pic29MenuElementChild = page_getPic29MenuElement($childPage, $level + 1);
			if($pic29MenuElementChild == null) continue;
			$pic29MenuElements[] = $pic29MenuElementChild;
		}
		$pic29MenuElement->children = $pic29MenuElements;
		 
		
		return $pic29MenuElement;
	}