<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29MenuElement {
	var $url;
	var $label;
	var $id;
	var $description;
	var $isCurrent = false;
	var $level = 0;
	var $exclude_nav;
	var $dont_link;
	var $isHome=false;
}

class Pic29Menu {
	
	var $pic29MenuElements;
	
	var $title;
	var $parentPageCID;
	var $style;
	
	function __construct($obj = null) {}
	
	function majPic29MenuElements() {
		$this->pic29MenuElements = array();
		$db = Loader::db();
		$orderBy = "order by Pages.cDisplayOrder asc";
		$cParentID = $this->parentPageCID;
		
		$currentPage = Page::getCurrentPage();
		if($currentPage) {
			$currentPageId = ($currentPage->getCollectionPointerID() > 0) ? $currentPage->getCollectionPointerOriginalID() : $currentPage->getCollectionID();
			//$currentPageId = $currentPage->getCollectionID();
		} 
		
		$q = "select Pages.cID from Pages where cIsTemplate = 0 and cParentID = '{$cParentID}' {$orderBy}";
		$r = $db->query($q);
		if ($r) {
			while ($row = $r->fetchRow()) {
				$cID=$row['cID']; 
				if (!$this->canViewPage($cID)) continue;
				$pic29MenuElement = $this->getPic29MenuElement($cID);
				if ($currentPageId == $cID) {
					$pic29MenuElement->isCurrent = true;
				}
				$this->pic29MenuElements[]=$pic29MenuElement;
			}
		}
	}
	
	function canViewPage($cID) {
		
		$tc = Page::getByID($cID, "ACTIVE"); //recherche la page active
		
		if (!is_object($tc)) {return false;} //elle existe
		
		//exclude from nav ??
		if ($tc->getCollectionAttributeValue('exclude_nav')) {
			return false;
		}
		
		$tcv = $tc->getVersionObject();
	    if (!is_object($tcv)) {return false;}  //A une version
		
		if (!$tcv->isApproved()) {return false;} // A une version approuvée
		
		if ($tc->isSystemPage()) {return false;} //n'est pas une page système 
		//Page Not Found, Page Forbidden etc...
		
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		if ($pagePointerExternalLink != null) {return true;} //si pointeur externe ok
		
		$tcp = new Permissions($tc);
		if (!$tcp->canRead()) {return false;} //est autorisé pour l'utilisateur courant
		
		return true;
	}
	
	function getPic29MenuElement($cID) {
		$pic29MenuElement = new Pic29MenuElement();
		
		$pic29MenuElement->id = $cID;
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		$tc = Page::getByID($cID, "ACTIVE");
		$name = $tc->getCollectionName();
		$pagePath =  $tc->getCollectionPath();
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		$description = $tc->getCollectionDescription();
		
		$pic29MenuElement->label = $name;
		
		$pic29MenuElement->description = null;
		if ($description != null) {
			$description = trim($description);
			if (strcmp('', trim($description)) != 0) {
				$pic29MenuElement->description = $description;
			}
		}
		
		if (isset($pagePointerExternalLink)) {
			$pic29MenuElement->url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$pic29MenuElement->url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($this->pageCID== HOME_CID) {
			$pic29MenuElement->url = DIR_REL . '/';
		} else {
			$pic29MenuElement->url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		return $pic29MenuElement;
	}
}

class Pic29MenuBlockController extends BlockController {

	protected $btTable = 'btPic29MenuBlock';
	
	//chanhement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 800;
	protected $btInterfaceHeight = 400;
	
	public function getBlockTypeDescription() {
		return t("Création d'un menu.");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 menu");
	}
	
	public $pic29Menu;

	var $preview = false;

	function __construct($obj = null) {
		parent::__construct($obj);
	}

	
	function requestToMenu ($request) {
		
		$pic29Menu = new Pic29Menu();

		
		$pic29Menu->title = isset($request['title']) ? trim($request['title']) : '';
		$pic29Menu->parentPageCID  = intval($request['parentPageCID']) ? intval($request['parentPageCID']) : 0;
		$pic29Menu->style    = isset($request['style']) ? $request['style'] : 'menu_simple';
		$pic29Menu->cellWidth = intval($request['cellWidth']) ? intval($request['cellWidth']) : 135;
		
		return $pic29Menu;
	}
	
	function save($request) {
		$this->pic29Menu = $this->requestToMenu($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Menu);
		
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Menu = $this->requestToMenu($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Menu = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		
		$this->pic29Menu->majPic29MenuElements();
		
		$this->set('controller', $this);
	}
	
	function add() {
		$this->pic29Menu = new Pic29Menu();
	}
	
	function edit() {
		$this->loadData();
	}

}

include('fct_page.php');
include('fct_breacrumb.php');
include('fct_sitemap.php');
include('fct_main.php');

?>