<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29Link {
	
	var $isOpenInNewWindow;
	var $isDownload;
		
	var $file_id;
	var $url;
	var $page_id;

	var $link_label;
	var $link_tooltip;
		
	var $link_type;
	var $link_button_width; 
		
	var $link_image_id;
	var $link_image_over_id;
	var $link_image_width;
	var $link_image_height;
	
	function __construct($obj = null) {	}
	
}

class Pic29LinkBlockController extends BlockController {

	protected $btTable = 'btPic29LinkBlock';
	
	//chanhement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 800;
	protected $btInterfaceHeight = 500;
	
	public function getBlockTypeDescription() {
		return t("Creation d'un lien.");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 lien");
	}
	
	public $pic29Link;
	
	var $preview = false;

	public function getJavaScriptStrings() {
		return array(
			'image-required' => t('You must select an image.')
		);
	}
	
	function __construct($obj = null) {
		parent::__construct($obj);
	}
	
	function requestToModele ($request) {
		
		$pic29Link = new Pic29Link();
		
		$pic29Link->file_id   = ($request['file_id'] != '') ? $request['file_id'] : 0;
		$pic29Link->url       = ($request['url'] != '') ? $request['url'] : '';
		$pic29Link->page_id   = ($request['page_id'] != '') ? $request['page_id'] : 0;
		
		$pic29Link->url = trim($pic29Link->url);
		
		$pic29Link->isOpenInNewWindow 	= isset($request['isOpenInNewWindow']) ? true : false;
		$pic29Link->isDownload 			= isset($request['isDownload']) ? true : false;

		$pic29Link->link_label		    = isset($request['link_label']) ? $request['link_label'] : null;
		$pic29Link->link_tooltip		= isset($request['link_tooltip']) ? $request['link_tooltip'] : null;
		
		$pic29Link->link_type		    = isset($request['link_type']) ? $request['link_type'] : 'simple';
		$pic29Link->link_button_width   =  intval($request['link_button_width']) ? intval($request['link_button_width']) : 0; 
		
		$pic29Link->link_image_id       =  ($request['link_image_id'] != '') ? $request['link_image_id'] : 0;
		$pic29Link->link_image_over_id  =  ($request['link_image_over_id'] != '') ? $request['link_image_over_id'] : 0;
		$pic29Link->link_image_width    = isset($request['link_image_width']) ? intval($request['link_image_width']) : null;
		$pic29Link->link_image_height   = isset($request['link_image_height']) ? intval($request['link_image_height']) : null;
		
		return $pic29Link;
		
	}
	
	
	
	function save($request) {
		$this->pic29Link = $this->requestToModele($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Link);
		
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Link = $this->requestToModele($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Link = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		$this->set('controller', $this);		
	}
	
	function add() {
		$this->pic29Link = new Pic29Link();
	}
	
	function edit() {
		$this->loadData();
	}
	
	function getPageUrl($page) {
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		//$name = $page->getCollectionName();
		$pagePath =  $page->getCollectionPath();
		$pagePointerExternalLink = $page->getCollectionPointerExternalLink();
		
		if (isset($pagePointerExternalLink)) {
			$url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($this->pageCID== HOME_CID) {
			$url = DIR_REL . '/';
		} else {
			$url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		return $url;
	}

}

?>