<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29Lightbox {
	
	
	var $lightbox_width;
	var $lightbox_height;
	
	var $lightbox_description;
	
	var $image_id;
	var $file_id;
	var $page_id;
	var $html = '';
	var $url;

	var $isIFrame;
	
	var $link_label;
	var $link_tooltip;
	var $link_image_id;
	var $link_image_over_id;
	var $link_image_width;
	var $link_image_height;
	
	function __construct($obj = null) {	}
	
}

class Pic29LightboxBlockController extends BlockController {

	protected $btTable = 'btPic29LightboxBlock';
	
	//chanhement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 800;
	protected $btInterfaceHeight = 500;
	
	public function getBlockTypeDescription() {
		return t("Creation d'un lien lightbox.");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 lightbox");
	}
	
	public $pic29Lightbox;
	
	var $preview = false;
	
	function __construct($obj = null) {
		parent::__construct($obj);
	}
	
	function requestToModele ($request) {
		
		$pic29Lightbox = new Pic29Lightbox();
		
		$pic29Lightbox->image_id  =  ($request['image_id'] != '') ? $request['image_id'] : 0;
		$pic29Lightbox->file_id   =  ($request['file_id'] != '') ? $request['file_id'] : 0;
		$pic29Lightbox->page_id   =  ($request['page_id'] != '') ? $request['page_id'] : 0;
		$pic29Lightbox->html      = isset($request['html']) ? $request['html'] : '';
		$pic29Lightbox->url       =  ($request['url'] != '') ? $request['url'] : '';
		
		$pic29Lightbox->html = $this->getContentToSave($pic29Lightbox->html);		
		$pic29Lightbox->url = trim($pic29Lightbox->url);
		
		$pic29Lightbox->lightbox_width = isset($request['lightbox_width']) ? intval($request['lightbox_width']) : null;
		$pic29Lightbox->lightbox_height = isset($request['lightbox_height']) ? intval($request['lightbox_height']) : null;
		$pic29Lightbox->lightbox_description= isset($request['lightbox_description']) ? $request['lightbox_description'] : '';
		
		$pic29Lightbox->isIFrame = isset($request['isIFrame']) ? true : false;

		$pic29Lightbox->link_label         = isset($request['link_label']) ? $request['link_label'] : '';
		$pic29Lightbox->link_tooltip       = isset($request['link_tooltip']) ? $request['link_tooltip'] : '';
		$pic29Lightbox->link_image_id      =  ($request['link_image_id'] != '') ? $request['link_image_id'] : 0;
		$pic29Lightbox->link_image_over_id =  ($request['link_image_over_id'] != '') ? $request['link_image_over_id'] : 0;
		$pic29Lightbox->link_image_width = isset($request['link_image_width']) ? intval($request['link_image_width']) : null;
		$pic29Lightbox->link_image_height = isset($request['link_image_height']) ? intval($request['link_image_height']) : null;

		$pic29Lightbox->link_label       = trim($pic29Lightbox->link_label);
		$pic29Lightbox->link_tooltip     = trim($pic29Lightbox->link_tooltip);
		
		return $pic29Lightbox;
		
	}
	
	
	
	function save($request) {
		$this->pic29Lightbox = $this->requestToModele($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Lightbox);
		
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Lightbox = $this->requestToModele($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Lightbox = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		$this->pic29Lightbox->html = $this->getContentViewMode($this->pic29Lightbox->html);
		$this->set('controller', $this);
	}
	
	function add() {
		$this->pic29Lightbox = new Pic29Lightbox();
	}
	
	function edit() {
		$this->loadData();
		$this->pic29Lightbox->html = $this->getContentEditMode($this->pic29Lightbox->html);
	}
	
	function getPageUrl($page) {
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		//$name = $page->getCollectionName();
		$pagePath =  $page->getCollectionPath();
		$pagePointerExternalLink = $page->getCollectionPointerExternalLink();
		
		if (isset($pagePointerExternalLink)) {
			$url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($this->pageCID== HOME_CID) {
			$url = DIR_REL . '/';
		} else {
			$url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		return $url;
	}
	
	/////////////////////////////
	/////////////////////////////
	
		var $className = 'Pic29LightboxBlockController';
	
		function br2nl($str) {
			$str = str_replace("\r\n", "\n", $str);
			$str = str_replace("<br />\n", "\n", $str);
			return $str;
		}
		
		public function getSearchableContent(){
			return $this->pic29Lightbox->html;
		}

		function getContentEditMode($text) {
			// old stuff. Can remove in a later version.
			$text = str_replace('href="{[CCM:BASE_URL]}', 'href="' . BASE_URL . DIR_REL, $text);
			$text = str_replace('src="{[CCM:REL_DIR_FILES_UPLOADED]}', 'src="' . BASE_URL . REL_DIR_FILES_UPLOADED, $text);

			// we have the second one below with the backslash due to a screwup in the
			// 5.1 release. Can remove in a later version.

			$text = preg_replace(
				array(
					'/{\[CCM:BASE_URL\]}/i',
					'/{CCM:BASE_URL}/i'),
				array(
					BASE_URL . DIR_REL,
					BASE_URL . DIR_REL)
				, $text);
				
			// now we add in support for the links
			
			$text = preg_replace(
				'/{CCM:CID_([0-9]+)}/i',
				BASE_URL . DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=\\1',
				$text);

			// now we add in support for the files
			
			$text = preg_replace_callback(
				'/{CCM:FID_([0-9]+)}/i',
				array($this->className, 'replaceFileIDInEditMode'),				
				$text);
			

			return $text;
		}
		
		function getContentViewMode($text) {
			
			// old stuff. Can remove in a later version.
			$text = str_replace('href="{[CCM:BASE_URL]}', 'href="' . BASE_URL . DIR_REL, $text);
			$text = str_replace('src="{[CCM:REL_DIR_FILES_UPLOADED]}', 'src="' . BASE_URL . REL_DIR_FILES_UPLOADED, $text);

			// we have the second one below with the backslash due to a screwup in the
			// 5.1 release. Can remove in a later version.

			$text = preg_replace(
				array(
					'/{\[CCM:BASE_URL\]}/i',
					'/{CCM:BASE_URL}/i'),
				array(
					BASE_URL . DIR_REL,
					BASE_URL . DIR_REL)
				, $text);
				
			// now we add in support for the links
			
			$text = preg_replace_callback(
				'/{CCM:CID_([0-9]+)}/i',
				array($this->className, 'replaceCollectionID'),				
				$text);

			$text = preg_replace_callback(
				'/<img [^>]*src\s*=\s*"{CCM:FID_([0-9]+)}"[^>]*>/i',
				array($this->className, 'replaceImageID'),				
				$text);

			// now we add in support for the files that we view inline			
			$text = preg_replace_callback(
				'/{CCM:FID_([0-9]+)}/i',
				array($this->className, 'replaceFileID'),				
				$text);

			// now files we download
			
			$text = preg_replace_callback(
				'/{CCM:FID_DL_([0-9]+)}/i',
				array($this->className, 'replaceDownloadFileID'),				
				$text);
			
			return $text;
		}
		
		private function replaceFileID($match) {
			$fID = $match[1];
			if ($fID > 0) {
				$path = File::getRelativePathFromID($fID);
				return $path;
			}
		}
		
		private function replaceImageID($match) {
			$fID = $match[1];
			if ($fID > 0) {
				preg_match('/width\s*="([0-9]+)"/',$match[0],$matchWidth);
				preg_match('/height\s*="([0-9]+)"/',$match[0],$matchHeight);
				$file = File::getByID($fID);
				if (is_object($file) && (!$file->isError())) {
					$imgHelper = Loader::helper('image');
					$maxWidth = ($matchWidth[1]) ? $matchWidth[1] : $file->getAttribute('width');
					$maxHeight = ($matchHeight[1]) ? $matchHeight[1] : $file->getAttribute('height');
					if ($file->getAttribute('width') > $maxWidth || $file->getAttribute('height') > $maxHeight) {
						$thumb = $imgHelper->getThumbnail($file, $maxWidth, $maxHeight);
						return preg_replace('/{CCM:FID_([0-9]+)}/i', $thumb->src, $match[0]);
					}
				}
				return $match[0];
			}
		}

		private function replaceDownloadFileID($match) {
			$fID = $match[1];
			if ($fID > 0) {
				$c = Page::getCurrentPage();
				return View::url('/download_file', 'view', $fID, $c->getCollectionID());
			}
		}

		private function replaceFileIDInEditMode($match) {
			$fID = $match[1];
			return View::url('/download_file', 'view_inline', $fID);
		}
		
		private function replaceCollectionID($match) {
			$cID = $match[1];
			if ($cID > 0) {
				$c = Page::getByID($cID, 'APPROVED');
				return Loader::helper("navigation")->getLinkToCollection($c);
			}
		}
		
		function getContentToSave($text) {
			// keep links valid
			$url1 = str_replace('/', '\/', BASE_URL . DIR_REL . '/' . DISPATCHER_FILENAME);
			$url2 = str_replace('/', '\/', BASE_URL . DIR_REL);
			$url3 = View::url('/download_file', 'view_inline');
			$url3 = str_replace('/', '\/', $url3);
			$url3 = str_replace('-', '\-', $url3);
			$url4 = View::url('/download_file', 'view');
			$url4 = str_replace('/', '\/', $url4);
			$url4 = str_replace('-', '\-', $url4);
			$text = preg_replace(
				array(
					'/' . $url1 . '\?cID=([0-9]+)/i', 
					'/' . $url3 . '([0-9]+)\//i', 
					'/' . $url4 . '([0-9]+)\//i', 
					'/' . $url2 . '/i'),
				array(
					'{CCM:CID_\\1}',
					'{CCM:FID_\\1}',
					'{CCM:FID_DL_\\1}',
					'{CCM:BASE_URL}')
				, $text);
			return $text;
		}
}

?>