<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));


class Pic29Googlemap {
	
	var	$longitude ='-3.910087';
	var $latitude = '47.876008';
	var $zoom = '15';
	var $width = '600';
	var $height = '400';
	
	var $mapType = 'G_HYBRID_MAP';
	var $infoWindow =  '';
	var $isInfoWindow = false;
	var $isUI = true;
	
	var $isEditMode = false;
	var $isPreview = false;
	
	function __construct() {
		$c = Page::getCurrentPage();
		if (isset($c)) {
			$isEditMode = $c->isEditMode() ? 'true' : 'false';
		} else {
			$isEditMode = true; //si pas de page, preview en fait
		}
		$this->isEditMode = $isEditMode;
	}
}


class Pic29GooglemapBlockController extends BlockController {

	protected $btTable = 'btPic29GooglemapBlock';
	
	//changement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 900;
	protected $btInterfaceHeight = 500;
	
	public function getBlockTypeDescription() {
		return t("Gestion de google map");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 google map");
	}
	
	public $pic29Googlemap;

	var $preview = false;

	function __construct($obj = null) {
		parent::__construct($obj);
	}

	
	function requestToPic29Googlemap ($request) {
		
		$pic29Googlemap = new Pic29Googlemap();
		
		$pic29Googlemap->longitude = isset($request['longitude']) ? floatval($request['longitude']) : -3.910087;
		$pic29Googlemap->latitude = isset($request['latitude']) ? floatval($request['latitude']) :  47.876008;
		$pic29Googlemap->zoom = isset($request['zoom']) ? intval($request['zoom']) : 15;
		$pic29Googlemap->width = isset($request['width']) ? intval($request['width']) : 600;
		$pic29Googlemap->height = isset($request['height']) ? intval($request['height']) : 400;
		
		$pic29Googlemap->isUI = isset($request['isUI']) ? true : false;
		
		$pic29Googlemap->mapType = isset($request['mapType']) ? $request['mapType'] : 'G_HYBRID_MAP';
		
		$pic29Googlemap->isInfoWindow = isset($request['isInfoWindow']) ? true : false;;
		$pic29Googlemap->infoWindow = isset($request['infoWindow']) ? $request['infoWindow'] : '';
		$pic29Googlemap->infoWindow = $this->getContentToSave($pic29Googlemap->infoWindow);
		
		//suppress carriage return and line feed
		//$pic29Googlemap->infoWindow = trim( preg_replace( '/\s+/', ' ', $pic29Googlemap->infoWindow ) );
		//$pic29Googlemap->infoWindow=preg_replace ('/\'/', '&#180;', $pic29Googlemap->infoWindow); // convertie toutes les '
		
		//$pic29Googlemap->infoWindow=preg_replace ('/"/', '&#34;', $pic29Googlemap->infoWindow); // convertie toutes les "
		
		
		return $pic29Googlemap;
	}
	
	function save($request) {
		$this->pic29Googlemap = $this->requestToPic29Googlemap($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Googlemap);
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Googlemap = $this->requestToPic29Googlemap($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Googlemap = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->pic29Googlemap->isPreview = false;
			$this->loadData();
		} else {
			$this->pic29Googlemap->isPreview = true;
		}
		$this->pic29Googlemap->infoWindow = $this->getContentViewMode($this->pic29Googlemap->infoWindow);
		$this->set('controller', $this);
	}
	
	function add() {
		$this->pic29Googlemap = new Pic29Googlemap();
	}
	
	function edit() {
		$this->loadData();
		$this->pic29Googlemap->infoWindow = $this->getContentEditMode($this->pic29Googlemap->infoWindow);
	}
	
	/////////////////
	
	public function on_before_render() {}
	
	/////////////////////////////
	/////////////////////////////
	
		var $className = 'Pic29GooglemapBlockController';
	
		function br2nl($str) {
			$str = str_replace("\r\n", "\n", $str);
			$str = str_replace("<br />\n", "\n", $str);
			return $str;
		}
		
		public function getSearchableContent(){
			return $this->pic29Lightbox->html;
		}

		function getContentEditMode($text) {
			// old stuff. Can remove in a later version.
			$text = str_replace('href="{[CCM:BASE_URL]}', 'href="' . BASE_URL . DIR_REL, $text);
			$text = str_replace('src="{[CCM:REL_DIR_FILES_UPLOADED]}', 'src="' . BASE_URL . REL_DIR_FILES_UPLOADED, $text);

			// we have the second one below with the backslash due to a screwup in the
			// 5.1 release. Can remove in a later version.

			$text = preg_replace(
				array(
					'/{\[CCM:BASE_URL\]}/i',
					'/{CCM:BASE_URL}/i'),
				array(
					BASE_URL . DIR_REL,
					BASE_URL . DIR_REL)
				, $text);
				
			// now we add in support for the links
			
			$text = preg_replace(
				'/{CCM:CID_([0-9]+)}/i',
				BASE_URL . DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=\\1',
				$text);

			// now we add in support for the files
			
			$text = preg_replace_callback(
				'/{CCM:FID_([0-9]+)}/i',
				array($this->className, 'replaceFileIDInEditMode'),				
				$text);
			

			return $text;
		}
		
		function getContentViewMode($text) {
			
			// old stuff. Can remove in a later version.
			$text = str_replace('href="{[CCM:BASE_URL]}', 'href="' . BASE_URL . DIR_REL, $text);
			$text = str_replace('src="{[CCM:REL_DIR_FILES_UPLOADED]}', 'src="' . BASE_URL . REL_DIR_FILES_UPLOADED, $text);

			// we have the second one below with the backslash due to a screwup in the
			// 5.1 release. Can remove in a later version.

			$text = preg_replace(
				array(
					'/{\[CCM:BASE_URL\]}/i',
					'/{CCM:BASE_URL}/i'),
				array(
					BASE_URL . DIR_REL,
					BASE_URL . DIR_REL)
				, $text);
				
			// now we add in support for the links
			
			$text = preg_replace_callback(
				'/{CCM:CID_([0-9]+)}/i',
				array($this->className, 'replaceCollectionID'),				
				$text);

			$text = preg_replace_callback(
				'/<img [^>]*src\s*=\s*"{CCM:FID_([0-9]+)}"[^>]*>/i',
				array($this->className, 'replaceImageID'),				
				$text);

			// now we add in support for the files that we view inline			
			$text = preg_replace_callback(
				'/{CCM:FID_([0-9]+)}/i',
				array($this->className, 'replaceFileID'),				
				$text);

			// now files we download
			
			$text = preg_replace_callback(
				'/{CCM:FID_DL_([0-9]+)}/i',
				array($this->className, 'replaceDownloadFileID'),				
				$text);
			
			return $text;
		}
		
		private function replaceFileID($match) {
			$fID = $match[1];
			if ($fID > 0) {
				$path = File::getRelativePathFromID($fID);
				return $path;
			}
		}
		
		private function replaceImageID($match) {
			$fID = $match[1];
			if ($fID > 0) {
				preg_match('/width\s*="([0-9]+)"/',$match[0],$matchWidth);
				preg_match('/height\s*="([0-9]+)"/',$match[0],$matchHeight);
				$file = File::getByID($fID);
				if (is_object($file) && (!$file->isError())) {
					$imgHelper = Loader::helper('image');
					$maxWidth = ($matchWidth[1]) ? $matchWidth[1] : $file->getAttribute('width');
					$maxHeight = ($matchHeight[1]) ? $matchHeight[1] : $file->getAttribute('height');
					if ($file->getAttribute('width') > $maxWidth || $file->getAttribute('height') > $maxHeight) {
						$thumb = $imgHelper->getThumbnail($file, $maxWidth, $maxHeight);
						return preg_replace('/{CCM:FID_([0-9]+)}/i', $thumb->src, $match[0]);
					}
				}
				return $match[0];
			}
		}

		private function replaceDownloadFileID($match) {
			$fID = $match[1];
			if ($fID > 0) {
				$c = Page::getCurrentPage();
				return View::url('/download_file', 'view', $fID, $c->getCollectionID());
			}
		}

		private function replaceFileIDInEditMode($match) {
			$fID = $match[1];
			return View::url('/download_file', 'view_inline', $fID);
		}
		
		private function replaceCollectionID($match) {
			$cID = $match[1];
			if ($cID > 0) {
				$c = Page::getByID($cID, 'APPROVED');
				return Loader::helper("navigation")->getLinkToCollection($c);
			}
		}
		
		function getContentToSave($text) {
			// keep links valid
			$url1 = str_replace('/', '\/', BASE_URL . DIR_REL . '/' . DISPATCHER_FILENAME);
			$url2 = str_replace('/', '\/', BASE_URL . DIR_REL);
			$url3 = View::url('/download_file', 'view_inline');
			$url3 = str_replace('/', '\/', $url3);
			$url3 = str_replace('-', '\-', $url3);
			$url4 = View::url('/download_file', 'view');
			$url4 = str_replace('/', '\/', $url4);
			$url4 = str_replace('-', '\-', $url4);
			$text = preg_replace(
				array(
					'/' . $url1 . '\?cID=([0-9]+)/i', 
					'/' . $url3 . '([0-9]+)\//i', 
					'/' . $url4 . '([0-9]+)\//i', 
					'/' . $url2 . '/i'),
				array(
					'{CCM:CID_\\1}',
					'{CCM:FID_\\1}',
					'{CCM:FID_DL_\\1}',
					'{CCM:BASE_URL}')
				, $text);
			return $text;
		}

}

?>