var pic29buttonBlock={}; 

pic29buttonBlock.initWidget = function () {
	pic29buttonBlock.$form = $("#ccm-block-form");
	
	pic29buttonBlock.$typeLink = pic29buttonBlock.$form.find("select[name=typeLink]");
	pic29buttonBlock.$pageSelector = pic29buttonBlock.$form.find(".page_selector");
	pic29buttonBlock.$externalSelector = pic29buttonBlock.$form.find(".external_selector");
	
	pic29buttonBlock.$displayPagesCID = pic29buttonBlock.$form.find("input[name=displayPagesCID]");
	pic29buttonBlock.$autonavPreviewPaneUrl = pic29buttonBlock.$form.find("input[name=autonavPreviewPaneUrl]");
	
	pic29buttonBlock.$loaderHTML = $('<div style="padding: 20px; text-align: center"><img src="' + CCM_IMAGE_PATH + '/throbber_white_32.gif"></div>');
	
	pic29buttonBlock.$previewPane = pic29buttonBlock.$form.find('#ccm-autonavPane-preview');
}

pic29buttonBlock.reloadPreview = function() {
	
	var autonavPreviewPaneUrl = pic29buttonBlock.$autonavPreviewPaneUrl.val();
	
	pic29buttonBlock.$previewPane.html(pic29buttonBlock.$loaderHTML);
	$.ajax({
		type: 'POST',
		url: autonavPreviewPaneUrl,
		data:pic29buttonBlock.$form.serialize(),
		success: function(resp) {
			pic29buttonBlock.$previewPane.html(resp);
			$("#ccm-auto-nav").css('opacity',1);
		}		
	});
};

pic29buttonBlock.autonavTabSetup = function() {
	//on click on tab button find tib id to whow pane
	$('ul#ccm-autonav-tabs li a').bind("click", function (event){
		var paneId = $(this).attr("id").replace('ccm-autonav-tab-','');
		pic29buttonBlock.autonavShowPane(paneId);
	});		
};

pic29buttonBlock.autonavShowPane = function (paneId){
	
	var pane    = $('#ccm-autonavPane-'+paneId);
	var paneTab = $('#ccm-autonav-tab-'+paneId);
	
	$('ul#ccm-autonav-tabs li').removeClass('ccm-nav-active');
	paneTab.parent().addClass('ccm-nav-active');
	
	$('div.ccm-autonavPane').hide();
	pane.show();

	if(paneId=='preview') pic29buttonBlock.reloadPreview();
};

pic29buttonBlock.autonavBindWidget= function() {
	pic29buttonBlock.$typeLink.bind("change", function(event){
		pic29buttonBlock.majSelector();
	});
};

pic29buttonBlock.majSelector = function () {
	var val = pic29buttonBlock.$typeLink.val();
	if (val == "page") {
		pic29buttonBlock.$pageSelector.show();
		pic29buttonBlock.$externalSelector.hide();
		
	} else if (val == "external") {
		pic29buttonBlock.$pageSelector.hide();
		pic29buttonBlock.$externalSelector.show();
	};
};

	
$(function() {
	pic29buttonBlock.initWidget();
	pic29buttonBlock.autonavTabSetup();
	pic29buttonBlock.autonavBindWidget();
	pic29buttonBlock.majSelector();
	pic29buttonBlock.reloadPreview();
	}
);

ccmValidateBlockForm = function() {
	var fID = pic29buttonBlock.$form.find("input[name=fID]").val();
	if (fID == '' || fID == 0) { 
		ccm_addError(ccm_t('image-required'));
		return false;
	}
	return true;
}
