<?php  
defined('C5_EXECUTE') or die(_("Access Denied."));

	class PageearBlockController extends BlockController {
		
		protected $btTable = 'btPageEar';
		protected $btInterfaceWidth = "450";
		protected $btInterfaceHeight = "400";
		
		/** 
		 * Used for localization. If we want to localize the name/description we have to include this
		 */
		public function getBlockTypeDescription() {
			return t("Add a Page Ear to your site.");
		}
		
		public function getBlockTypeName() {
			return t("Page Ear");
		}
		public function getJavaScriptStrings() {
			return array(
				'small-image-required' => t('You must select a small image. '),
				'small-image-extension' => t('The small image\'s extension is not jpg or jpeg. '),
				'big-image-required' => t('You must select a big image. '),
				'big-image-extension' => t('The big image\'s extension is not jpg or jpeg. ')
			);
		}
			
		function getBlockPath() {
			$uh = Loader::helper('concrete/urls'); 
			$bt = BlockType::getByHandle('Pageear'); 
			$local = $uh->getBlockTypeAssetsURL($bt); 
			return $local;
		}
		
		function getSmallImageID() {
			return $this->pagearSmallImg;
		}
		function getBigImageID() {
			return $this->pagearBigImg;
		}
		function getBigImageObject() {
			return File::getByID($this->pagearBigImg);
		}
		function getSmallImageObject() {
			return File::getByID($this->pagearSmallImg);
		}		
		
		public function save($args) {
			if($args['mirror'] == "") {
				$args['mirror'] = "false";
			} else {
				$args['mirror'] = "true";
			}
			$args['closeOnLoad'] = str_replace(",",".",$args['closeOnLoad']);
			if($args['closeOnLoad'] == "") {
				$args['closeOnLoad'] = "5";
			}
			$args['openOnLoad'] = str_replace(",",".",$args['openOnLoad']);
			if($args['openOnLoad'] == "") {
				$args['openOnLoad'] = "1";
			}
			$args['pageearColor'] = str_replace("#","",$args['pageearColor']);
			if($args['pageearColor'] == "" && $args['mirror'] != "true") {
				$args['pageearColor'] = "FFFFFF";
			}
			parent::save($args);		
		}
	}
	
?>