(function( $, undefined ) {

	
$.widget( "ui.pic29GooglemapController", $.Widget, {
	// default options
	options: {
		longitude : 0, 
		latitude : 45, 
		width : 200, 
		height : 200, 
		zoom : 10, 
		mapType : 'G_HYBRID_MAP',
		isInfoWindow : false,
		infoWindow : '', 
		isPreview : false, 
		isEditMode : false,
		isUI : true
	},
	
	// constructor 
	_create: function() {
		this.map = null;
		this._setInit();
		
	 	if (this.options.isPreview == true) {
			this._register();
		}
		this._setInfoWindow();
	},
	
	_setInit : function() {
		if (!GBrowserIsCompatible()) return;
		
		var domContainer = document.getElementById(this.element.attr('id'));

		this.map = new GMap2(
				domContainer, 
	 			{size: new GSize(
	 					this.options.width,
	 					this.options.height)
				}
	 	);
		
	 	this.map.setCenter(
	 		new GLatLng(
	 				this.options.latitude,
	 				this.options.longitude), 
	 		this.options.zoom
	 	);
	 	
	 	
	 	var mapType = eval(this.options.mapType);
		this.map.setMapType(mapType);
		
		if (this.options.isUI) {
			this.map.setUIToDefault();
		}
		
		this.input_latitude  = $('input:[name=latitude]');
		this.input_longitude = $('input:[name=longitude]');
		this.input_zoom = $('select:[name=zoom]');
	},
	
	_setInfoWindow : function () {
		if (!this.options.isInfoWindow) return;
		if($.trim(this.options.infoWindow) != '') {
			this.map.clearOverlays();
			this.map.openInfoWindowHtml(this.map.getCenter(), this.options.infoWindow);
		}
	},

	
	_mapToForm : function () {
		var map = this.map;
	 	var center = map.getCenter();
	 	this.input_latitude.val(center.lat().toFixed(5));
	 	this.input_longitude.val(center.lng().toFixed(5));
	 	this.input_zoom.val(map.getZoom());
	 	this._setInfoWindow();
	},
	
	_register : function() {
		var self = this;
		this.listener1 = GEvent.bind(this.map, 'dragend', this, function() {
				self._mapToForm();
		 });
		 
		 this.listener2 = GEvent.bind(this.map, 'zoomend', this, function(overlay, latlng) {
				self._mapToForm();
		 });
	},
	_unregister : function() {
		//génère une erreur googlemap en cas d'update...
		//a is undefined main.js ligne 175
		//[Stopper sur une erreur] function F(a){a.remove();ud(me).Pj(a)} 
		//GEvent.removeListener(this.listener1);
		//GEvent.removeListener(this.listener2);
	},
	
	destroy: function() {
		this._unregister();
		// call super
		$.Widget.prototype.destroy.apply( this, arguments );
		// now do other stuff particular to this widget
		
	},
	
	_setOption: function( key, value ) {
		// call super
		$.Widget.prototype._setOption.apply( this, arguments );
	}
	
});

$.extend( $.ui.pic29GooglemapController, {
	version: "1.0"
});

})( jQuery );