<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29MultiLanguageElement {
	var $langue;
	var $pageCID;
}

class Pic29MultiLanguage {
	var $elements;
	function __construct() {
		$this->elements = array();
		
		$pic29MultiLanguageElement = new Pic29MultiLanguageElement();
		$pic29MultiLanguageElement->langue = 'fr';
		$pic29MultiLanguageElement->pageCID = 0;
		$this->elements[] = $pic29MultiLanguageElement;
		
		$pic29MultiLanguageElement = new Pic29MultiLanguageElement();
		$pic29MultiLanguageElement->langue = 'en';
		$pic29MultiLanguageElement->pageCID = 0;
		$this->elements[] = $pic29MultiLanguageElement;
	}
}


class Pic29MultiLanguageBlockController extends BlockController {

	protected $btTable = 'btPic29MultiLanguageBlock';
	
	//changement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 1000;
	protected $btInterfaceHeight = 400;
	
	public function getBlockTypeDescription() {
		return t("Gestion des langues");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 multi langage");
	}
	
	public $pic29MultiLanguage;

	var $preview = false;

	function __construct($obj = null) {
		parent::__construct($obj);
	}

	
	function requestToPic29MultiLanguage ($request) {
		
		$pic29MultiLanguage = new Pic29MultiLanguage();
		$pic29MultiLanguage->elements = array();
		
		foreach ($request['langue'] as $key => $langue) {
			
			if (!isset($langue)) continue;
			
			$pageCID = $request['pageCID'][$key];
			if (!isset($pageCID)) continue;
			
			$langue = trim($langue);
			if($langue === '') continue; 

			$pic29MultiLanguageElement = new Pic29MultiLanguageElement();
			$pic29MultiLanguageElement->langue = $langue;
			$pic29MultiLanguageElement->pageCID = $pageCID;
			$pic29MultiLanguage->elements[] = $pic29MultiLanguageElement;
		}
		
		return $pic29MultiLanguage;
	}
	
	function save($request) {
		$this->pic29MultiLanguage = $this->requestToPic29MultiLanguage($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29MultiLanguage);
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29MultiLanguage = $this->requestToPic29MultiLanguage($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29MultiLanguage = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		$this->set('controller', $this);
	}
	
	function add() {
		$this->pic29MultiLanguage = new Pic29MultiLanguage();
	}
	
	function edit() {
		$this->loadData();
	}
	
	/////////////////
	
	//juste avant header("Content-Type: text/html; charset=" . APP_CHARSET);
	// de l'object.methode  View.render()
	public function on_before_render() {
		//redirection vers page		
		$c = Page::getCurrentPage();
		$cp = new Permissions($c);
		if (!$cp->canAdminPage()) {
			$userLanguageElement = $this->getUserLanguageElement();
			$href =  $this->getPageUrl($userLanguageElement->pageCID);
			header('Location:'. $href);
			exit(0);
		}
	}
	
	
	function getPageUrl($cID) {
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		$tc = Page::getByID($cID, "ACTIVE");
		
		$pagePath =  $tc->getCollectionPath();
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		
		if (isset($pagePointerExternalLink)) {
			return $pagePointerExternalLink;
		} else if ($pagePath) {
			return  DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($cID == HOME_CID) {
			return DIR_REL . '/';
		} else {
			return DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}		
	}
	
	
	function getUserLanguageElement() {
		$elements = $this->pic29MultiLanguage->elements;
		$default = $elements[0];
		
		$_AL=strtolower($_SERVER['HTTP_ACCEPT_LANGUAGE']);
		$_UA=strtolower($_SERVER['HTTP_USER_AGENT']);
		
		foreach ($elements as $element) {
			$langue = $element->langue;
			if(strpos($_AL, $langue)===0)
			return $element;
		}
		
		foreach ($elements as $element) {
			$langue = $element->langue;
			if(strpos($_AL, $langue)!==false)
			return $element;
		}
		
		foreach ($elements as $element) {
			$langue = $element->langue;
			if(preg_match("/[\[\( ]{$langue}[;,_\-\)]/",$_UA))
			return $element;
		}
		// Return default language if language is not yet detected.
		return $default;		
	}

}

?>