<?php  
defined('C5_EXECUTE') or die(_("Access Denied."));

function sitemap_getChildPages($c) {
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		// a quickie
		$db = Loader::db();
		$r = $db->query("select cID from Pages where cParentID = ? order by cDisplayOrder asc", array($c->getCollectionID()));
		$pages = array();
		while ($row = $r->fetchRow()) {
			$pages[] = Page::getByID($row['cID']);
		}
		return $pages;
	}
	
	function sitemap_canViewPage($c) {
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		$tc = Page::getByID($cID, "ACTIVE"); //recherche la page active
		
		if (!is_object($tc)) {return false;} //elle existe
		
		
		$tcv = $tc->getVersionObject();
	    if (!is_object($tcv)) {return false;}  //A une version
		
		if (!$tcv->isApproved()) {return false;} // A une version approuvée
		
		if ($tc->isSystemPage()) {return false;} //n'est pas une page système 
		//Page Not Found, Page Forbidden etc...
		
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		if ($pagePointerExternalLink != null) {return true;} //si pointeur externe ok
		
		$tcp = new Permissions($tc);
		if (!$tcp->canRead()) {return false;} //est autorisé pour l'utilisateur courant
		
		return true;
	}
	
	function sitemap_getPic29MenuElement($c) {
		
		if(!sitemap_canViewPage($c)) return null;
		
		
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		$tc = Page::getByID($cID, "ACTIVE");
		
		if ($tc->getCollectionAttributeValue('exclude_sitemap')) {
			return false;
		}
		
		$pic29MenuElement = new Pic29MenuElement();
		$pic29MenuElement->id = $cID;
		
		if ($tc->getCollectionAttributeValue('exclude_nav')) {
			$pic29MenuElement->exclude_nav = true;
		} else {
			$pic29MenuElement->exclude_nav = false;
		}
		
		$name = $tc->getCollectionName();
		$pagePath =  $tc->getCollectionPath();
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		$description = $tc->getCollectionDescription();
		
		$pic29MenuElement->label = $name;
		
		$pic29MenuElement->description = null;
		if ($description != null) {
			$description = trim($description);
			if (strcmp('', trim($description)) != 0) {
				$pic29MenuElement->description = $description;
			}
		}
		
		if (isset($pagePointerExternalLink)) {
			$pic29MenuElement->url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$pic29MenuElement->url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($cID == HOME_CID) {
			$pic29MenuElement->url = DIR_REL . '/';
		} else {
			$pic29MenuElement->url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		$childPages = sitemap_getChildPages($c);
		
		$pic29MenuElements = array(); 
		foreach($childPages as $childPage) {
			$pic29MenuElementChild = sitemap_getPic29MenuElement($childPage);
			if($pic29MenuElementChild == null) continue;
			$pic29MenuElements[] = $pic29MenuElementChild;
		}
		$pic29MenuElement->children = $pic29MenuElements; 
		
		return $pic29MenuElement;
	}
	
	function sitemap_display($pic29MenuElement) {
		sitemap_displayElement($pic29MenuElement);
		
		
		$children = $pic29MenuElement->children;
		if (isset($children) && sizeof($children) > 0) {
			echo "<ul>";
			foreach ($children as $child) {
				sitemap_display($child);
			}
			echo "</ul>";
		} else {
		}
	}
	
	function sitemap_displayElement($pic29MenuElement) {
		echo "<li>";
		$url   = $pic29MenuElement->url;
		$label = $pic29MenuElement->label;
		if ($pic29MenuElement->exclude_nav) {
			echo "{$label}";
		} else {
			echo "<a href='{$url}'>{$label}</a>";
		} 
		echo "</li>";
	}
	