<?php  
defined('C5_EXECUTE') or die(_("Access Denied."));

	function bc_canViewPage($c) {
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		$tc = Page::getByID($cID, "ACTIVE"); //recherche la page active
		
		if (!is_object($tc)) {return false;} //elle existe
		
		//exclude from nav ??
		if ($tc->getCollectionAttributeValue('exclude_nav')) {
			return false;
		}
		
		$tcv = $tc->getVersionObject();
	    if (!is_object($tcv)) {return false;}  //A une version
		
		if (!$tcv->isApproved()) {return false;} // A une version approuvée
		
		if ($tc->isSystemPage()) {return false;} //n'est pas une page système 
		//Page Not Found, Page Forbidden etc...
		
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		if ($pagePointerExternalLink != null) {return true;} //si pointeur externe ok
		
		$tcp = new Permissions($tc);
		if (!$tcp->canRead()) {return false;} //est autorisé pour l'utilisateur courant
		
		return true;
	}
	
	function bc_getPic29MenuElement($c) {
		$pic29MenuElement = new Pic29MenuElement();
		
		if($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
		}
		
		$pic29MenuElement->id = $cID;
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		$tc = Page::getByID($cID, "ACTIVE");
		$name = $tc->getCollectionName();
		$pagePath =  $tc->getCollectionPath();
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		$description = $tc->getCollectionDescription();
		
		$pic29MenuElement->label = $name;
		
		$pic29MenuElement->description = null;
		if ($description != null) {
			$description = trim($description);
			if (strcmp('', trim($description)) != 0) {
				$pic29MenuElement->description = $description;
			}
		}
		
		if (isset($pagePointerExternalLink)) {
			$pic29MenuElement->url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$pic29MenuElement->url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($cID == HOME_CID) {
			$pic29MenuElement->url = DIR_REL . '/';
		} else {
			$pic29MenuElement->url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		return $pic29MenuElement;
	}
	
	function bc_getDummyPic29MenuElement($i) {
		$pic29MenuElement = new Pic29MenuElement();
	 	$pic29MenuElement->label = "Page $i";
	 	$pic29MenuElement->description = "Description $i";
	 	$pic29MenuElement->url = "javascript:void(0);"; 
	 	return $pic29MenuElement;
	}
	
	
	function bc_getPageNext($page=NULL) {
		if ($page == null) {
			$pageNext = Page::getCurrentPage();
		} else {
			$parentID = $page->getCollectionParentID();
			$pageNext = Page::getByID($parentID, "ACTIVE");
		}
		return $pageNext;
	}
	