var pic29Menu={}; 

pic29Menu.initWidget = function () {
	pic29Menu.$form = $("#ccm-block-form");
	
	pic29Menu.$typeLink = pic29Menu.$form.find("select[name=typeLink]");
	pic29Menu.$pageSelector = pic29Menu.$form.find(".page_selector");
	pic29Menu.$externalSelector = pic29Menu.$form.find(".external_selector");
	
	pic29Menu.$displayPagesCID = pic29Menu.$form.find("input[name=displayPagesCID]");
	pic29Menu.$previewPaneUrl = pic29Menu.$form.find("input[name=previewPaneUrl]");
	
	pic29Menu.$loaderHTML = $('<div style="padding: 20px; text-align: center"><img src="' + CCM_IMAGE_PATH + '/throbber_white_32.gif"></div>');
	
	pic29Menu.$previewPane = pic29Menu.$form.find('#ccm-autonavPane-preview');
}

pic29Menu.reloadPreview = function() {
	
	var previewPaneUrl = pic29Menu.$previewPaneUrl.val();
	
	pic29Menu.$previewPane.html(pic29Menu.$loaderHTML);
	$.ajax({
		type: 'POST',
		url: previewPaneUrl,
		data:pic29Menu.$form.serialize(),
		success: function(resp) {
			pic29Menu.$previewPane.html(resp);
			$("#ccm-auto-nav").css('opacity',1);
		}		
	});
};

pic29Menu.autonavTabSetup = function() {
	//on click on tab button find tib id to whow pane
	$('ul#ccm-autonav-tabs li a').bind("click", function (event){
		var paneId = $(this).attr("id").replace('ccm-autonav-tab-','');
		pic29Menu.autonavShowPane(paneId);
	});		
};

pic29Menu.autonavShowPane = function (paneId){
	
	var pane    = $('#ccm-autonavPane-'+paneId);
	var paneTab = $('#ccm-autonav-tab-'+paneId);
	
	$('ul#ccm-autonav-tabs li').removeClass('ccm-nav-active');
	paneTab.parent().addClass('ccm-nav-active');
	
	$('div.ccm-autonavPane').hide();
	pane.show();

	if(paneId=='preview') pic29Menu.reloadPreview();
};

pic29Menu.autonavBindWidget= function() {
	pic29Menu.$typeLink.bind("change", function(event){
		pic29Menu.majSelector();
	});
};

pic29Menu.majSelector = function () {
	var val = pic29Menu.$typeLink.val();
	if (val == "page") {
		pic29Menu.$pageSelector.show();
		pic29Menu.$externalSelector.hide();
		
	} else if (val == "external") {
		pic29Menu.$pageSelector.hide();
		pic29Menu.$externalSelector.show();
	};
};

	
$(function() {
	pic29Menu.initWidget();
	pic29Menu.autonavTabSetup();
	pic29Menu.autonavBindWidget();
	pic29Menu.majSelector();
	pic29Menu.reloadPreview();
	}
);

