<?php  
defined('C5_EXECUTE') or die(_("Access Denied."));

$pic29Menu = $controller->pic29Menu;
$pic29MenuElements = $pic29Menu->pic29MenuElements; 

$bID = $controller->bID;

$idMenu = 'pic29_menu_' . $bID;

echo "<div class='pic29_menu' id='{$idMenu}'>";

foreach ($pic29MenuElements as $i => $pic29MenuElement) {

	$url=$pic29MenuElement->url;
	$label=$pic29MenuElement->label;
	$id=$pic29MenuElement->id;
	$description=$pic29MenuElement->description;
	
	$meta; //create en object
	$meta->tooltip = false;
	if ($description != null) {
		$meta->descriptionId = "menu_description_{$id}";
		$meta->tooltip = true;
	}
	
	$json_meta = json_encode($meta);
	
	echo "<a class='menu_element {$json_meta}' id='menu_element_{$id}' title='' href='{$url}'>{$label}</a>\n";
	if ($description != null) {
		echo "<div class='menu_description' id='menu_description_{$id}' style='display:none;'>{$description}</div>\n";
	}
	echo "<br/>";	
}
echo "</div>";

echo "
<script type='text/javascript'>
<!--
$(function(){
    if (typeof pic29main == 'undefined') return;
    var menu = $('#{$idMenu}');
    var menu_elements = menu.find('.menu_element');
    menu_elements.each(function(index, element) {
    	var jqthis = $(element);
    	var metadata = jqthis.metadata();
    	if (metadata.tooltip == false) return;
    	
    	jqthis.tooltip({
	    	 bodyHandler: function() {
	    	 	var jqthis = $(this);
	    	 	var metadata = jqthis.metadata();
	    	 	var descriptionId = metadata.descriptionId;
	    	 	var jqDecription= $('#' + descriptionId);
	    	 	return jqDecription.html();
	    	}, 
	    	showURL: false 
		});
    });
    
});
//-->
</script>
";

		
