<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29MainMenuBlockItem {

	private $level;
	private $isActive = false;
	private $_c;
	

	
	/**
	 * Instantiates an Autonav Block Item. 
	 * @param array $itemInfo 
	 * @param int $level
	 */
	function __construct($itemInfo, $level = 1) {

		$this->level = $level;
		if (is_array($itemInfo)) {
			// this is an array pulled from a separate SQL query
			foreach ($itemInfo as $key => $value) {
				$this->{$key} = $value;
			}
		}

		return $this;
	}
	
	/**
	 * Returns the number of children below this current nav item
	 * @return int
	 */
	function hasChildren() {
		return count($this->subNavigationItems);
	}
	
	/**
	 * Determines whether this nav item is the current page the user is on. 
	 * @param Page $page The page object for the current page
	 * @return bool
	 */
	function isActive(&$c) {
		if ($c) {
			$cID = ($c->getCollectionPointerID() > 0) ? $c->getCollectionPointerOriginalID() : $c->getCollectionID();
			return ($cID == $this->cID);
		}
	}

	/**
	 * Returns the description of the current navigation item (typically grabbed from the page's short description field)
	 * @return string
	 */
	function getDescription() {
		return $this->cvDescription;
	}

	/** 
	 * Gets a URL that will take the user to this particular page. Checks against URL_REWRITING, the page's path, etc..
	 * @return string $url
	 */
	function getURL() {
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		if ($this->cPointerExternalLink != '') {
			$link = $this->cPointerExternalLink;
		} else if ($this->cPath) {
			$link = DIR_REL . $dispatcher . $this->cPath . '/';
		} else if ($this->cID == HOME_CID) {
			$link = DIR_REL . '/';
		} else {
			$link = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->cID;
		}
		return $link;
	}
	
	/**
	 * Gets the name of the page or link.
	 * @return string
	 */
	function getName() {
		return $this->cvName;
	}
	
	/**
	 * Gets the pageID for the navigation item.
	 * @return int
	 */
	function getCollectionID() {
		return $this->cID;
	}
	
	
	/**
	 * Gets the current level at the nav tree that we're at.
	 * @return int
	 */
	function getLevel() {
		return $this->level;
	}
	
	/** 
	 * Sets the collection Object of the navigation item to the passed object
	 * @param Page $obj
	 * @return void
	 */
	function setCollectionObject(&$obj) {
		$this->_c = $obj;
	}
	
	/**
	 * Gets the collection Object of the navigation item
	 * @return Page
	 */
	function getCollectionObject() {
		return $this->_c;
	}
}




/**
 *  
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author  
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
 
class Pic29MainMenu {
	
	var $displayPages;  		
	var $displayPagesCID;		
	
	var $displaySubPageLevelsNum; 
	 
	
	var $cellWidth;				
	
	var $displaySubPages = "all";
	var $displaySubPageLevels = "custom"; 
	var $orderBy = "display_asc" ;
	var $displayUnavailablePages = false;

}

class Pic29MainMenuBlockController extends BlockController {

	protected $btTable = 'btPic29MainMenuBlock';
	
	//chanhement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 500;
	protected $btInterfaceHeight = 400;
	
	public function getBlockTypeDescription() {
		return t("Creates dropdown navigation menus");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 Main Menu");
	}
	
	public $pic29MainMenu;

	var $navArray = array();
	var $cParentIDArray = array();

	var $sorted_array = array();
	var $navSort = array();
	var $navObjectNames = array();
	
	var $preview = false;

	var $haveRetrievedSelf = false;
	var $haveRetrievedSelfPlus1 = false;
	var $displaySystemPages = false;
	
	// private variable $displayUnapproved, used by the dashboard
	var $displayUnapproved = false;

	// haveRetrievedSelf is a variable that stores whether or not a particular tree walking operation has retrieved the current page. We use this
	// with subpage modes like enough and enough_plus1

	// displayUnavailablePages allows us to decide whether this autonav block filters out unavailable pages (pages we can't see, are restricted, etc...)
	// or whether they display them, but then restrict them when the page is actually visited
	// TODO - Implement displayUnavailablePages in the btNavigation table, and in the frontend of the autonav block

	function __construct($obj = null) {
		
		if(is_object($obj)) {
			$type = strtolower(get_class($obj));
		}
		switch($type) {
			case "blocktype":
				// instantiating autonav on a particular collection page, instead of adding
				// it through the block interface
				$this->bID = null;
				global $c;
				if (is_object($c)) {
					$this->cID = $c->getCollectionID();
					$this->cParentID = $c->getCollectionParentID();
				}
				break;
			case "block": // block
				// standard block object
				$this->bID = $obj->bID;
				$cobj = $obj->getBlockCollectionObject();
				$this->cID = ($cobj->getCollectionPointerID()) ? $cobj->getCollectionPointerOriginalID() : $cobj->getCollectionID();
				$this->displayCID = $cobj->getCollectionID();
				$this->cParentID = $cobj->cParentID;
				break;
		}
		
		parent::__construct($obj);
	}

	
	function requestToPic29MainMenu ($request) {
		
		$pic29MainMenu = new Pic29MainMenu();
		
		$pic29MainMenu->displayPages = isset($request['displayPages']) ? $request['displayPages'] : 'top';
		$pic29MainMenu->displayPagesCID = intval($request['displayPagesCID']) ? intval($request['displayPagesCID']) : 0;
		
		$pic29MainMenu->displaySubPageLevelsNum = $request['displaySubPageLevelsNum'] > 0 ? $request['displaySubPageLevelsNum'] : 0;
		
		$pic29MainMenu->cellWidth = intval($request['cellWidth']) ? intval($request['cellWidth']) : 135;
		$pic29MainMenu->menuColor = isset($request['menuColor']) ? $request['menuColor'] : 'blue';
		
		return $pic29MainMenu;
	}
	
	function save($request) {
		$this->pic29MainMenu = $this->requestToPic29MainMenu($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29MainMenu);
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29MainMenu = $this->requestToPic29MainMenu($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29MainMenu = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		
		$aBlocks = $this->generateNav();
		
		//On met les variables utiles dans la vue
		$this->set('aBlocks', $aBlocks);
		$this->set('pic29MainMenu', $this->pic29MainMenu);
		$this->set('bID', $this->bID);
		
	}
	
	function add() {
		$this->pic29MainMenu = new Pic29MainMenu();
		$this->pic29MainMenu->autoWidthMode = 1;
	}
	
	function edit() {
		$this->loadData();
	}

	public function getChildPages($c) {
	
		// a quickie
		$db = Loader::db();
		$r = $db->query("select cID from Pages where cParentID = ? order by cDisplayOrder asc", array($c->getCollectionID()));
		$pages = array();
		while ($row = $r->fetchRow()) {
			$pages[] = Page::getByID($row['cID']);
		}
		return $pages;
	}
	
	function generateNav() {
		
		$pic29MainMenu = $this->pic29MainMenu;
		
		$db = Loader::db();
		// now we proceed, with information obtained either from the database, or passed manually from
		$orderBy = "";

		switch($pic29MainMenu->orderBy) {
			case 'display_asc':
				$orderBy = "order by Pages.cDisplayOrder asc";
				break;
			case 'display_desc':
				$orderBy = "order by Pages.cDisplayOrder desc";
				break;
			default:
				$orderBy = '';
				break;
		}
		$level = 0;
		$cParentID = 0;
		switch($pic29MainMenu->displayPages) {
			case 'current':
				$cParentID = $this->cParentID;
				if ($cParentID < 1) {
					$cParentID = 1;
				}
				break;
			case 'top':
				// top level actually has ID 1 as its parent, since the home page is effectively alone at the top
				$cParentID = 1;
				break;
			case 'above':
				$cParentID = $this->getParentParentID();
				break;
			case 'below':
				$cParentID = $this->cID;
				break;
			case 'second_level':
				$cParentID = $this->getParentAtLevel(2);
				break;
			case 'third_level':
				$cParentID = $this->getParentAtLevel(3);
				break;
			case 'custom':
				$cParentID = $pic29MainMenu->displayPagesCID;
				break;
			default:
				$cParentID = 1;
				break;
		}
		
		if ($cParentID != null) {

			if ($pic29MainMenu->displaySubPages == 'relevant' || $pic29MainMenu->displaySubPages == 'relevant_breadcrumb') {
				$this->populateParentIDArray($this->cID);
			}

			$this->getNavigationArray($cParentID, $orderBy, $level);

		}
		
		return $this->navArray;
	}

	function getParentAtLevel($level) {
		// this function works in the following way
		// we go from the current collection up to the top level. Then we find the parent Id at the particular level specified, and begin our
		// autonav from that point

		$this->populateParentIDArray($this->cID);

		$idArray = array_reverse($this->cParentIDArray);
		$this->cParentIDArray = array();
		if ($level - count($idArray) == 0) {
			// This means that the parent ID array is one less than the item
			// we're trying to grab - so we return our CURRENT page as the item to get
			// things under
			return $this->cID;
		}
		
		if (isset($idArray[$level])) {
			return $idArray[$level];
		} else {
			return null;
		}
	}

	function getNavigationArray($cParentID, $orderBy, $currentLevel) {
		$db = Loader::db();
		$navSort = $this->navSort;
		$sorted_array = $this->sorted_array;
		$navObjectNames = $this->navObjectNames;

		$allowedParentIDs = ($allowedParentIDs) ? $allowedParentIDs : array();
		$q = "select Pages.cID from Pages where cIsTemplate = 0 and cParentID = '{$cParentID}' {$orderBy}";
		$r = $db->query($q);
		if ($r) {
			while ($row = $r->fetchRow()) {
				if ($this->pic29MainMenu->displaySubPages != 'relevant_breadcrumb' || (in_array($row['cID'], $this->cParentIDArray) || $row['cID'] == $this->cID)) {
					/*
					if ($this->haveRetrievedSelf) {
						// since we've already retrieved self, and we're going through again, we set plus 1
						$this->haveRetrievedSelfPlus1 = true;
					} else 
					*/
					
					if ($this->haveRetrievedSelf && $cParentID == $this->cID) {
						$this->haveRetrievedSelfPlus1 = true;
					} else if ($row['cID'] == $this->cID) {
						$this->haveRetrievedSelf = true;
					}
					
					$displayPage = true;
					if ($this->displayUnapproved) {
						$tc = Page::getByID($row['cID'], "RECENT");
					} else {
						$tc = Page::getByID($row['cID'], "ACTIVE");
					}
					
					if ($tc->isSystemPage() && (!$this->displaySystemPages)) { 
						if (!($tc->getCollectionPath() == '/members' && Config::get('ENABLE_USER_PROFILES'))) {
							continue; 
						}
					}
					
					$tcv = $tc->getVersionObject();
					if ((!is_object($tcv)) || (!$tcv->isApproved() && !$this->displayUnapproved)) { 
						$displayPage = false;
					}
					
					if ($this->displayUnavailablePages == false) {
						$tcp = new Permissions($tc);
						if (!$tcp->canRead() && ($tc->getCollectionPointerExternalLink() == null)) {
							$displayPage = false;
						}
					}

					if ($displayPage) {
						$niRow = array();
						$niRow['cvName'] = $tc->getCollectionName();
						$niRow['cID'] = $row['cID'];
						$niRow['cvDescription'] = $tc->getCollectionDescription();
						$niRow['cPath'] = $tc->getCollectionPath();
						$niRow['cPointerExternalLink'] = $tc->getCollectionPointerExternalLink();
						$dateKey = strtotime($tc->getCollectionDatePublic());

						$ni = new Pic29MainMenuBlockItem($niRow, $currentLevel);
						$ni->setCollectionObject($tc);
						// $this->navArray[] = $ni;
						$navSort[$niRow['cID']] = $dateKey;
						$sorted_array[$niRow['cID']] = $ni;

						$_c = $ni->getCollectionObject();
						$object_name = $_c->getCollectionName();
						$navObjectNames[$niRow['cID']] = $object_name;

					}

				}
			}
			// end while -- sort navSort

			// Joshua's Huge Sorting Crap
			if($navSort) {
				$sortit=0;
				if($this->pic29MainMenu->orderBy == "chrono_asc") { asort($navSort); $sortit=1; }
				if($this->pic29MainMenu->orderBy == "chrono_desc") { arsort($navSort); $sortit=1; }

				if($sortit) {
					foreach($navSort as $sortCID => $sortdatewhocares) {
						// create sorted_array
						$this->navArray[] = $sorted_array[$sortCID];

						#############start_recursive_crap
						$retrieveMore = false;
						if ($this->pic29MainMenu->displaySubPages == 'all') {
							if ($this->pic29MainMenu->displaySubPageLevels == 'all' || ($this->pic29MainMenu->displaySubPageLevels == 'custom' && $this->pic29MainMenu->displaySubPageLevelsNum > $currentLevel)) {
								$retrieveMore = true;
							}
						} else if (($this->pic29MainMenu->displaySubPages == "relevant" || $this->pic29MainMenu->displaySubPages == "relevant_breadcrumb") && (in_array($sortCID, $this->cParentIDArray) || $sortCID == $this->cID)) {
							if ($this->pic29MainMenu->displaySubPageLevels == "enough" && $this->haveRetrievedSelf == false) {
								$retrieveMore = true;
							} else if ($this->pic29MainMenu->displaySubPageLevels == "enough_plus1" && $this->haveRetrievedSelfPlus1 == false) {
								$retrieveMore = true;
							} else if ($this->pic29MainMenu->displaySubPageLevels == 'all' || ($this->pic29MainMenu->displaySubPageLevels == 'custom' && $this->pic29MainMenu->displaySubPageLevelsNum > $currentLevel)) {
								$retrieveMore = true;
							}
						}
						if ($retrieveMore) {
							$this->getNavigationArray($sortCID, $orderBy, $currentLevel + 1);
						}
						#############end_recursive_crap
					}
				}

				$sortit=0;
				if($this->pic29MainMenu->orderBy == "alpha_desc") { arsort($navObjectNames); $sortit=1; }
				if($this->pic29MainMenu->orderBy == "alpha_asc") { asort($navObjectNames); $sortit=1; }

				if($sortit) {
					foreach($navObjectNames as $sortCID => $sortnameaction) {
						// create sorted_array
						$this->navArray[] = $sorted_array[$sortCID];

						#############start_recursive_crap
						$retrieveMore = false;
						if ($this->pic29MainMenu->displaySubPages == 'all') {
							if ($this->pic29MainMenu->displaySubPageLevels == 'all' || ($this->pic29MainMenu->displaySubPageLevels == 'custom' && $this->pic29MainMenu->displaySubPageLevelsNum > $currentLevel)) {
								$retrieveMore = true;
							}
						} else if (($this->pic29MainMenu->displaySubPages == "relevant" || $this->pic29MainMenu->displaySubPages == "relevant_breadcrumb") && (in_array($sortCID, $this->cParentIDArray) || $sortCID == $this->cID)) {
							if ($this->pic29MainMenu->displaySubPageLevels == "enough" && $this->haveRetrievedSelf == false) {
								$retrieveMore = true;
							} else if ($this->pic29MainMenu->displaySubPageLevels == "enough_plus1" && $this->haveRetrievedSelfPlus1 == false) {
								$retrieveMore = true;
							} else if ($this->pic29MainMenu->displaySubPageLevels == 'all' || ($this->pic29MainMenu->displaySubPageLevels == 'custom' && $this->pic29MainMenu->displaySubPageLevelsNum > $currentLevel)) {
								$retrieveMore = true;
							}
						}
						if ($retrieveMore) {
							$this->getNavigationArray($sortCID, $orderBy, $currentLevel + 1);
						}
						#############end_recursive_crap
					}
				}

				$sortit=0;
				if($this->pic29MainMenu->orderBy == "display_desc") { $sortit=1; }
				if($this->pic29MainMenu->orderBy == "display_asc") { $sortit=1; }

				if($sortit) {
					// for display order? this stuff is already sorted...
					foreach($navObjectNames as $sortCID => $sortnameaction) {
						// create sorted_array
						$this->navArray[] = $sorted_array[$sortCID];

						#############start_recursive_crap
						$retrieveMore = false;
						if ($this->pic29MainMenu->displaySubPages == 'all') {
							if ($this->pic29MainMenu->displaySubPageLevels == 'all' || ($this->pic29MainMenu->displaySubPageLevels == 'custom' && $this->pic29MainMenu->displaySubPageLevelsNum > $currentLevel)) {
								$retrieveMore = true;
							}
						} else if (($this->pic29MainMenu->displaySubPages == "relevant" || $this->pic29MainMenu->displaySubPages == "relevant_breadcrumb") && (in_array($sortCID, $this->cParentIDArray) || $sortCID == $this->cID)) {
							if ($this->pic29MainMenu->displaySubPageLevels == "enough" && $this->haveRetrievedSelf == false) {
								$retrieveMore = true;
							} else if ($this->pic29MainMenu->displaySubPageLevels == "enough_plus1" && $this->haveRetrievedSelfPlus1 == false) {
								$retrieveMore = true;
							} else if ($this->pic29MainMenu->displaySubPageLevels == 'all' || ($this->pic29MainMenu->displaySubPageLevels == 'custom' && $this->pic29MainMenu->displaySubPageLevelsNum > $currentLevel)) {
								$retrieveMore = true;
							}
						}
						if ($retrieveMore) {
							$this->getNavigationArray($sortCID, $orderBy, $currentLevel + 1);
						}
						#############end_recursive_crap
					}
				}
			}
			// End Joshua's Huge Sorting Crap

		}
	}

	function populateParentIDArray($cID) {
		// returns an array of collection IDs going from the top level to the current item
		$db = Loader::db();
		$q = "select cParentID from Pages where cID = '$cID'";
		$r = $db->querycache(10, $q);
		$row = $r->fetchRow();
		$cParentID = $row['cParentID'];
		if ($cParentID > -1) {
			if ($cParentID != $stopAt) {
				if (!in_array($cParentID, $this->cParentIDArray)) {
					$this->cParentIDArray[] = $cParentID;
				}
				$this->populateParentIDArray($cParentID);
			}
		}

	}

	function getParentParentID($cParentID) {
		// this has to be the stupidest name of a function I've ever created. sigh
		$db = Loader::db();
		$q = "select cParentID from Pages where cID = '{$cParentID}'";
		$r = $db->querycache(10, $q);
		$row = $r->fetchRow();
		$cParentID = $row['cParentID'];
		return ($cParentID) ? $cParentID : 0;
	}
}

?>