var pic29MainMenu={}; 

pic29MainMenu.initWidget = function () {
	pic29MainMenu.$form = $("#ccm-block-form");
	pic29MainMenu.$displayPages = pic29MainMenu.$form.find("select[name=displayPages]");
	pic29MainMenu.$pageSelector = pic29MainMenu.$form.find("#page-selector");
	
	pic29MainMenu.$displaySubPageLevelsNum = pic29MainMenu.$form.find("select[name=displaySubPageLevelsNum]");
	pic29MainMenu.$displayPagesCID = pic29MainMenu.$form.find("input[name=displayPagesCID]");
	pic29MainMenu.$autonavPreviewPaneUrl = pic29MainMenu.$form.find("input[name=autonavPreviewPaneUrl]");
	
	pic29MainMenu.$loaderHTML = $('<div style="padding: 20px; text-align: center"><img src="' + CCM_IMAGE_PATH + '/throbber_white_32.gif"></div>');
	
	pic29MainMenu.$previewPane = pic29MainMenu.$form.find('#ccm-autonavPane-preview');
}

pic29MainMenu.reloadPreview = function() {
	
	var autonavPreviewPaneUrl = pic29MainMenu.$autonavPreviewPaneUrl.val();
	
	pic29MainMenu.$previewPane.html(pic29MainMenu.$loaderHTML);
	$.ajax({
		type: 'POST',
		url: autonavPreviewPaneUrl,
		data:pic29MainMenu.$form.serialize(),
		success: function(resp) {
			pic29MainMenu.$previewPane.html(resp);
			$("#ccm-auto-nav").css('opacity',1);
		}		
	});
};

pic29MainMenu.autonavTabSetup = function() {
	//on click on tab button find tib id to whow pane
	$('ul#ccm-autonav-tabs li a').bind("click", function (event){
		var paneId = $(this).attr("id").replace('ccm-autonav-tab-','');
		pic29MainMenu.autonavShowPane(paneId);
	});		
};

pic29MainMenu.autonavShowPane = function (paneId){
	
	var pane    = $('#ccm-autonavPane-'+paneId);
	var paneTab = $('#ccm-autonav-tab-'+paneId);
	
	$('ul#ccm-autonav-tabs li').removeClass('ccm-nav-active');
	paneTab.parent().addClass('ccm-nav-active');
	
	$('div.ccm-autonavPane').hide();
	pane.show();

	if(paneId=='preview') pic29MainMenu.reloadPreview();
};

pic29MainMenu.autonavBindWidget= function() {
	pic29MainMenu.$displayPages.bind("change", function(event){
		if (pic29MainMenu.$displayPages.val() == "custom") {
			pic29MainMenu.$pageSelector.show();
		} else {
			pic29MainMenu.$pageSelector.hide();
		}
	});
};
	
$(function() {
	pic29MainMenu.initWidget();
	pic29MainMenu.autonavTabSetup();
	pic29MainMenu.autonavBindWidget();
	pic29MainMenu.reloadPreview();
	}
);

