<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29Ligne {
	
	var $lines;
	var $style;
	
	function __construct($obj = null) {
		$this->lines = array_fill(0, 5, '');
	}
	
}

class Pic29LigneBlockController extends BlockController {

	protected $btTable = 'btPic29LigneBlock';
	
	//changement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 1000;
	protected $btInterfaceHeight = 400;
	
	public function getBlockTypeDescription() {
		return t("Creation d'une entête.");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 lignes");
	}
	
	public $pic29Ligne;

	var $preview = false;

	function __construct($obj = null) {
		parent::__construct($obj);
	}

	
	function requestToMenu ($request) {
		
		$pic29Ligne = new Pic29Ligne();
		
		$pic29Ligne->style    = isset($request['style']) ? $request['style'] : 'menu_simple';
		foreach ($request['line'] as $key => $line) {
		 	$pic29Ligne->lines[$key] = isset($line) ? trim($line) : '';
		}
		
		return $pic29Ligne;
	}
	
	function save($request) {
		$this->pic29Ligne = $this->requestToMenu($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Ligne);
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Ligne = $this->requestToMenu($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Ligne = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		$this->set('controller', $this);
	}
	
	function add() {
		$this->pic29Ligne = new Pic29Ligne();
	}
	
	function edit() {
		$this->loadData();
	}

}

?>