<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29Lightbox {
	
	
	var $lightbox_width;
	var $lightbox_height;
	
	var $lightbox_description;
	
	var $image_id;
	var $file_id;
	var $page_id;
	var $html = '';
	var $url;

	var $isIFrame;
	
	var $link_label;
	var $link_tooltip;
	var $link_image_id;
	var $link_image_over_id;
	var $link_image_width;
	var $link_image_height;
	
	function __construct($obj = null) {	}
	
}

class Pic29LightboxBlockController extends BlockController {

	protected $btTable = 'btPic29LightboxBlock';
	
	//chanhement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 800;
	protected $btInterfaceHeight = 500;
	
	public function getBlockTypeDescription() {
		return t("Creation d'un lien lightbox.");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 lightbox");
	}
	
	public $pic29Lightbox;
	
	var $preview = false;

	public function getJavaScriptStrings() {
		return array(
			'image-required' => t('You must select an image.')
		);
	}
	
	function __construct($obj = null) {
		parent::__construct($obj);
	}
	
	function requestToModele ($request) {
		
		$pic29Lightbox = new Pic29Lightbox();
		
		$pic29Lightbox->image_id  =  ($request['image_id'] != '') ? $request['image_id'] : 0;
		$pic29Lightbox->file_id   =  ($request['file_id'] != '') ? $request['file_id'] : 0;
		$pic29Lightbox->page_id   =  ($request['page_id'] != '') ? $request['page_id'] : 0;
		$pic29Lightbox->html      = isset($request['html']) ? $request['html'] : '';
		$pic29Lightbox->url       =  ($request['url'] != '') ? $request['url'] : '';
		
		$pic29Lightbox->html = trim($pic29Lightbox->html);
		$pic29Lightbox->url = trim($pic29Lightbox->url);
		
		$pic29Lightbox->lightbox_width = isset($request['lightbox_width']) ? intval($request['lightbox_width']) : null;
		$pic29Lightbox->lightbox_height = isset($request['lightbox_height']) ? intval($request['lightbox_height']) : null;
		$pic29Lightbox->lightbox_description= isset($request['lightbox_description']) ? $request['lightbox_description'] : '';
		
		$pic29Lightbox->isIFrame = isset($request['isIFrame']) ? true : false;

		$pic29Lightbox->link_label         = isset($request['link_label']) ? $request['link_label'] : '';
		$pic29Lightbox->link_tooltip       = isset($request['link_tooltip']) ? $request['link_tooltip'] : '';
		$pic29Lightbox->link_image_id      =  ($request['link_image_id'] != '') ? $request['link_image_id'] : 0;
		$pic29Lightbox->link_image_over_id =  ($request['link_image_over_id'] != '') ? $request['link_image_over_id'] : 0;
		$pic29Lightbox->link_image_width = isset($request['link_image_width']) ? intval($request['link_image_width']) : null;
		$pic29Lightbox->link_image_height = isset($request['link_image_height']) ? intval($request['link_image_height']) : null;

		$pic29Lightbox->link_label       = trim($pic29Lightbox->link_label);
		$pic29Lightbox->link_tooltip     = trim($pic29Lightbox->link_tooltip);
		
		return $pic29Lightbox;
		
	}
	
	
	
	function save($request) {
		$this->pic29Lightbox = $this->requestToModele($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Lightbox);
		
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Lightbox = $this->requestToModele($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Lightbox = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		$this->set('controller', $this);		
	}
	
	function add() {
		$this->pic29Lightbox = new Pic29Lightbox();
	}
	
	function edit() {
		$this->loadData();
	}
	
	function getPageUrl($page) {
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		//$name = $page->getCollectionName();
		$pagePath =  $page->getCollectionPath();
		$pagePointerExternalLink = $page->getCollectionPointerExternalLink();
		
		if (isset($pagePointerExternalLink)) {
			$url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($this->pageCID== HOME_CID) {
			$url = DIR_REL . '/';
		} else {
			$url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
		
		return $url;
	}

}

?>