<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));


class Pic29Googlemap {
	
	var	$longitude ='-3.910087';
	var $latitude = '47.876008';
	var $zoom = '15';
	var $width = '600';
	var $height = '400';
	
	var $mapType = 'G_HYBRID_MAP';
	var $infoWindow =  '';
	var $isInfoWindow = false;
	var $isUI = true;
	
	var $isEditMode = false;
	var $isPreview = false;
	
	function __construct() {
		$c = Page::getCurrentPage();
		if (isset($c)) {
			$isEditMode = $c->isEditMode() ? 'true' : 'false';
		} else {
			$isEditMode = true; //si pas de page, preview en fait
		}
		$this->isEditMode = $isEditMode;
	}
}


class Pic29GooglemapBlockController extends BlockController {

	protected $btTable = 'btPic29GooglemapBlock';
	
	//changement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 900;
	protected $btInterfaceHeight = 500;
	
	public function getBlockTypeDescription() {
		return t("Gestion de google map");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 google map");
	}
	
	public $pic29Googlemap;

	var $preview = false;

	function __construct($obj = null) {
		parent::__construct($obj);
	}

	
	function requestToPic29Googlemap ($request) {
		
		$pic29Googlemap = new Pic29Googlemap();
		
		$pic29Googlemap->longitude = isset($request['longitude']) ? floatval($request['longitude']) : -3.910087;
		$pic29Googlemap->latitude = isset($request['latitude']) ? floatval($request['latitude']) :  47.876008;
		$pic29Googlemap->zoom = isset($request['zoom']) ? intval($request['zoom']) : 15;
		$pic29Googlemap->width = isset($request['width']) ? intval($request['width']) : 600;
		$pic29Googlemap->height = isset($request['height']) ? intval($request['height']) : 400;
		
		$pic29Googlemap->isUI = isset($request['isUI']) ? true : false;
		
		$pic29Googlemap->mapType = isset($request['mapType']) ? $request['mapType'] : 'G_HYBRID_MAP';
		
		$pic29Googlemap->isInfoWindow = isset($request['isInfoWindow']) ? true : false;;
		$pic29Googlemap->infoWindow = isset($request['infoWindow']) ? $request['infoWindow'] : '';
		
		//suppress carriage return and line feed
		$pic29Googlemap->infoWindow = trim( preg_replace( '/\s+/', ' ', $pic29Googlemap->infoWindow ) );
		$pic29Googlemap->infoWindow=preg_replace ('/\'/', '&#180;', $pic29Googlemap->infoWindow); // convertie toutes les '
		
		//$pic29Googlemap->infoWindow=preg_replace ('/"/', '&#34;', $pic29Googlemap->infoWindow); // convertie toutes les "
		
		
		return $pic29Googlemap;
	}
	
	function save($request) {
		$this->pic29Googlemap = $this->requestToPic29Googlemap($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29Googlemap);
		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29Googlemap = $this->requestToPic29Googlemap($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29Googlemap = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->pic29Googlemap->isPreview = false;
			$this->loadData();
		} else {
			$this->pic29Googlemap->isPreview = true;
		}
		$this->set('controller', $this);
	}
	
	function add() {
		$this->pic29Googlemap = new Pic29Googlemap();
	}
	
	function edit() {
		$this->loadData();
	}
	
	/////////////////
	
	public function on_before_render() {
		/*
		$html = Loader::helper('html');
        $uh = Loader::helper('concrete/urls');
		$googlekey =  $this->pic29Googlemap->googlekey;
		$this->addHeaderItem($html->javascript("http://maps.google.com/maps?file=api&v=2&key=<?php echo $googlekey ?>"));
		*/
	}

}

?>