<?php  
/**
 * @package Blocks
 * @subpackage BlockTypes
 * @category Concrete
 * @author Andrew Embler <andrew@concrete5.org>
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */

/**
 * dropdown menus
 *
 * @package Blocks
 * @subpackage BlockTypes
 * @author Tony Trupp <tony@concrete5.org>
 * @category Concrete
 * @copyright  Copyright (c) 2003-2008 Concrete5. (http://www.concrete5.org)
 * @license    http://www.concrete5.org/license/     MIT License
 *
 */
defined('C5_EXECUTE') or die(_("Access Denied."));

class Pic29ButtonBlock {
	
	var $typeLink; //"page" "external"var $
	
	var $maxWidth;
	var $maxHeight;
	
	var $fID;
	var $fIDOver;
	
	var $url; //utilisé pour la sauvgarde et l'affichage
	var $description; //utilisé pour la sauvgarde et l'affichage
	var $canbeShown = true; //utilisé pour  l'affichage
	var $openInNewWindow = false;
			
	var $pageCID;	
	var $pageDescription;
	
	var $externalUrl;
	var $externalDescription;
	var $externalOpenInNewWindow = true;
	
	var $displayUnavailablePages = true;

	function __construct($obj = null) {
		
	}
	
	function majTypeLinkExternal() {
		$this->description = $this->externalDescription;
		$this->openInNewWindow = $this->externalOpenInNewWindow;
		$this->url = $this->externalUrl;
	}
	
	function majTypeLinkPage() {
		$this->description = $this->pageDescription;
		
		$dispatcher = '';
		if (!URL_REWRITING) {
			$dispatcher = '/index.php';
		}
		
		//must be an active page
		$tc = Page::getByID($this->pageCID, "ACTIVE");
		
		if (!is_object($tc)) {
			$this->canbeShown = false;
			return;
		}
	
		//must be approved
		$tcv = $tc->getVersionObject();
		if ((!is_object($tcv)) || (!$tcv->isApproved())) { 
			$this->canbeShown = false;
			return;
		}
			
		//$this->name = $tc->getCollectionName();
		//$this->description = $tc->getCollectionDescription();
		
		$pagePath =  $tc->getCollectionPath();
		$pagePointerExternalLink = $tc->getCollectionPointerExternalLink();
		
		//do not display unavailable pages, but not for external links
		if (!$this->displayUnavailablePages) {
			$tcp = new Permissions($tc);
			if (!$tcp->canRead() && ($pagePointerExternalLink == null)) {
				$this->canbeShown = false;
				return;
			}
		}
		
		if (isset($pagePointerExternalLink)) {
			$this->url = $pagePointerExternalLink;
		} else if ($pagePath) {
			$this->url = DIR_REL . $dispatcher . $pagePath . '/';
		} else if ($this->pageCID== HOME_CID) {
			$this->url = DIR_REL . '/';
		} else {
			$this->url = DIR_REL . '/' . DISPATCHER_FILENAME . '?cID=' . $this->pageCID;
		}
	}
}

class Pic29ButtonBlockBlockController extends BlockController {
	
	protected $btTable = 'btPic29ButtonBlockBlock';
	
	//chanhement dans block_controls pout prendre ces paramètres d'interface
	//à la place de ceux dans la bdd/cache de blocktype maj à l'install
	protected $btInterfaceWidth = 500;
	protected $btInterfaceHeight = 400;
	
	public function getBlockTypeDescription() {
		return t("Creates a simple button block link.");
	}
	
	public function getBlockTypeName() {
		return t("Pic29 Bouton Block");
	}
	
	public $pic29ButtonBlock;
	var $preview = false;

	public function getJavaScriptStrings() {
		return array(
			'image-required' => t('You must select an image.')
		);
	}
	
	function __construct($obj = null) {
		parent::__construct($obj);
	}

	
	function requestToButtonImage ($request) {
		
		$pic29ButtonBlock = new Pic29ButtonBlock();
		
		$pic29ButtonBlock->content = isset($request['content']) ? $request['content'] : '';
		
		$pic29ButtonBlock->width = intval($request['width']) ? intval($request['width']) : '0';
		$pic29ButtonBlock->height = intval($request['height']) ? intval($request['height']) : '0';
		$pic29ButtonBlock->color = isset($request['color']) ? $request['color'] : 'blue';
		
		$pic29ButtonBlock->typeLink = isset($request['typeLink']) ? $request['typeLink'] : 'external';
		
		$pic29ButtonBlock->externalUrl= isset($request['externalUrl']) ? $request['externalUrl'] : '';
		$pic29ButtonBlock->externalDescription= isset($request['externalDescription']) ? $request['externalDescription'] : '';
		$pic29ButtonBlock->externalOpenInNewWindow = isset($request['externalOpenInNewWindow']) ? true : false;
		
		$pic29ButtonBlock->pageCID  = intval($request['pageCID']) ? intval($request['pageCID']) : 0;
		$pic29ButtonBlock->pageDescription= isset($request['pageDescription']) ? $request['pageDescription'] : '';
		
		$pic29ButtonBlock->fID =  ($request['fID'] != '') ? $request['fID'] : 0;
		$pic29ButtonBlock->imageOffsetLeft = intval($request['imageOffsetLeft']) ? intval($request['imageOffsetLeft']) : '0';
		$pic29ButtonBlock->imageOffsetBottom = intval($request['imageOffsetBottom']) ? intval($request['imageOffsetBottom']) : '0';
		
		return $pic29ButtonBlock;
	}
	
	function save($request) {
		$this->pic29ButtonBlock = $this->requestToButtonImage($request);
		$args = array();
		$args['serialize'] = serialize($this->pic29ButtonBlock);

		parent::save($args);
	}

	function preparePreview($request) {
		$this->pic29ButtonBlock = $this->requestToButtonImage($request);
		$this->preview = true;
	}
	
	function loadData() {
        $this->pic29ButtonBlock = unserialize($this->serialize);
	}

	function view() {
		if (!$this->preview) {
			$this->loadData();
		}
		
		if ($this->pic29ButtonBlock->typeLink == 'page') {
			$this->pic29ButtonBlock->majTypeLinkPage();
		} else if ($this->pic29ButtonBlock->typeLink == 'external'){
			$this->pic29ButtonBlock->majTypeLinkExternal();
		}
		
		$this->set('controller', $this);		
	}
	
	function add() {
		$this->pic29ButtonBlock = new Pic29ButtonBlock();
	}
	
	function edit() {
		$this->loadData();
	}

}

?>